/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyItems;
import doggytalents.common.item.DogPlushieItem;
import doggytalents.common.util.NetworkUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class DogPlushie
extends Entity
implements IEntityAdditionalSpawnData {
    private int collarCollor = 11546150;
    private DogVariant variant = DogVariantUtil.getDefault();
    private boolean collarThicc = false;

    public DogPlushie(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    protected void m_8097_() {
    }

    public void setCollarColor(int val) {
        this.collarCollor = val;
    }

    public int getCollarColor() {
        return this.collarCollor;
    }

    public void setDogVariant(DogVariant variant) {
        this.variant = variant;
    }

    public DogVariant getDogVariant() {
        return this.variant;
    }

    public void setCollarThicc(boolean val) {
        this.collarThicc = val;
    }

    public boolean getCollarThicc() {
        return this.collarThicc;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("PlushCollarColor", 3)) {
            this.setCollarColor(compound.m_128451_("PlushCollarColor"));
        }
        if (compound.m_128425_("classicalVariant", 8)) {
            this.setDogVariant(DogVariantUtil.fromSaveString(compound.m_128461_("classicalVariant")));
        }
        this.setCollarThicc(compound.m_128471_("collarThicc"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("PlushCollarColor", this.getCollarColor());
        compound.m_128359_("classicalVariant", DogVariantUtil.toSaveString(this.getDogVariant()));
        compound.m_128379_("collarThicc", this.getCollarThicc());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.7));
        this.pushOtherPlush();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        if (this.m_213877_()) {
            return true;
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        return !(source.m_7640_() instanceof Player);
    }

    public boolean m_5825_() {
        return false;
    }

    public boolean m_21515_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.mayDropSelf(source);
        this.m_146870_();
        return true;
    }

    private void mayDropSelf(DamageSource source) {
        Entity entity = source.m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack drop = this.getDogPlusieItemDrop();
        if (!drop.m_41619_()) {
            this.m_19983_(drop);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item == Items.f_42000_) {
            if (!this.m_9236_().f_46443_ && player.m_6144_()) {
                this.m_146922_(this.m_146908_() + 45.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack getDogPlusieItemDrop() {
        DogPlushieItem item = DoggyItems.DOG_PLUSHIE_TOY.get();
        ItemStack stack = new ItemStack((ItemLike)item);
        item.m_41115_(stack, this.getCollarColor());
        return stack;
    }

    private void pushOtherPlush() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        List list = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(DogPlushie.class), this.m_20191_(), e -> true);
        for (DogPlushie e2 : list) {
            e2.m_7334_(this);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.writeInt(this.getCollarColor());
        NetworkUtil.writeDogVariantToBuf(buf, this.variant);
        buf.writeBoolean(this.getCollarThicc());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        int collar_color = buf.readInt();
        DogVariant variant = NetworkUtil.readDogVariantFromBuf(buf);
        boolean thicc = buf.readBoolean();
        this.setCollarColor(collar_color);
        this.setDogVariant(variant);
        this.setCollarThicc(thicc);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

